---
generated_at: 2026-02-10 15:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：99-VB REPL (vbi)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足（csi と同様と記載）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Interactive/vbi/Vbi.vb`
- E-02: `src/Scripting/Core/Hosting/CommandLine/CommandLineRunner.cs`
- E-03: `src/Scripting/VisualBasic/Hosting/VisualBasicInteractiveCompiler.vb`
- E-04: 機能一覧.csv（No.99 VB REPL (vbi)）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Vbi.Main エントリーポイント | E-01: 14-43行目 | ○ |
| C-02 | InteractiveResponseFileName = "vbi.rsp" | E-01: 12行目 | ○ |
| C-03 | vbi ディレクトリ取得 | E-01: 18行目 GetTypeInfo().Assembly | ○ |
| C-04 | BuildPaths 構築 | E-01: 20-24行目 | ○ |
| C-05 | VisualBasicInteractiveCompiler 作成 | E-01: 26-30行目 | ○ |
| C-06 | CommandLineRunner 作成 | E-01: 32-36行目 | ○ |
| C-07 | runner.RunInteractive() 呼び出し | E-01: 38行目 | ○ |
| C-08 | NotImplementedAnalyzerLoader 使用 | E-01: 30行目 | ○ |
| C-09 | VisualBasicScriptCompiler.Instance 使用 | E-01: 35行目 | ○ |
| C-10 | VisualBasicObjectFormatter.Instance 使用 | E-01: 36行目 | ○ |
| C-11 | 共通 CommandLineRunner 使用 | E-02: ファイル存在 | ○ |
| C-12 | Console.WriteLine でエラー出力 | E-01: 40行目 | ○ |
| C-13 | Return 1 でエラー終了 | E-01: 41行目 | ○ |
| C-14 | パフォーマンス要件 | **根拠なし**（csi と同様と記載） | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件**：csi と同様と記載したが、VB 固有の要件は確認されていない。
  - 候補：VB スクリプトのパフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - エントリーポイントの説明（ソースコード確認済み）
- 0: 低リスク - csi との共通部分の説明
- 1: 中リスク - パフォーマンス要件は csi からの推定

## 6) レビュアーチェックリスト（最小）
- [ ] Vbi.Main の処理フローが正確か
- [ ] csi との違いが正しく説明されているか
- [ ] VB 固有のコード例が適切か（VB 構文）
- [ ] コードリーディングガイドの行番号が最新コードと一致しているか
